/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.common.capability.BufferBlockCapabilityProvider;
import ca.teamdman.sfm.common.capability.CauldronBlockCapabilityProvider;
import ca.teamdman.sfm.common.capability.SFMWellKnownCapabilities;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.registry.SFMBlocks;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="sfm")
@MCVersionDependentBehaviour
public class SFMBlockCapabilities {
    @SubscribeEvent
    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, SFMBlockEntities.PRINTING_PRESS_BLOCK_ENTITY.get(), (blockEntity, direction) -> blockEntity.INVENTORY);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, SFMBlockEntities.WATER_TANK_BLOCK_ENTITY.get(), (blockEntity, direction) -> blockEntity.TANK);
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (IBlockCapabilityProvider)new IBlockCapabilityProvider<IItemHandler, Direction>(){

            @Nullable
            public IItemHandler getCapability(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, Direction context) {
                if (blockEntity instanceof BarrelBlockEntity) {
                    BarrelBlockEntity bbe = (BarrelBlockEntity)blockEntity;
                    return new InvWrapper((Container)bbe);
                }
                return null;
            }
        }, new Block[]{(Block)SFMBlocks.TEST_BARREL_BLOCK.get()});
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (IBlockCapabilityProvider)new IBlockCapabilityProvider<IItemHandler, Direction>(){

            @Nullable
            public IItemHandler getCapability(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, Direction context) {
                if (blockEntity instanceof BarrelBlockEntity) {
                    BarrelBlockEntity bbe = (BarrelBlockEntity)blockEntity;
                    return new InvWrapper((Container)bbe);
                }
                return null;
            }
        }, new Block[]{(Block)SFMBlocks.TEST_BARREL_BLOCK.get()});
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, SFMBlockEntities.TEST_BARREL_TANK_BLOCK_ENTITY.get(), (blockEntity, direction) -> blockEntity.getTank());
        event.registerBlock(Capabilities.FluidHandler.BLOCK, (IBlockCapabilityProvider)new CauldronBlockCapabilityProvider(), new Block[]{Blocks.CAULDRON, Blocks.LAVA_CAULDRON, Blocks.WATER_CAULDRON});
        event.registerBlockEntity(SFMWellKnownCapabilities.ITEM_HANDLER.capabilityKind(), SFMBlockEntities.MANAGER_BLOCK_ENTITY.get(), (manager, direction) -> manager.invWrapper);
        SFMResourceTypes.registry().values().forEach(resourceType -> SFMBlockCapabilities.registerCapabilitiesForResourceType(event, resourceType));
    }

    private static <STACK, ITEM, CAP> void registerCapabilitiesForResourceType(RegisterCapabilitiesEvent event, ResourceType<STACK, ITEM, CAP> resourceType) {
        BlockCapability<CAP, @Nullable Direction> resourceTypeBlockCapability = resourceType.capabilityKind().capabilityKind();
        event.registerBlock(resourceTypeBlockCapability, SFMBlockCapabilities.createProvider(resourceTypeBlockCapability), new Block[]{(Block)SFMBlocks.TUNNELLED_MANAGER_BLOCK.get()});
        BufferBlockCapabilityProvider bufferCapabilityProvider = new BufferBlockCapabilityProvider();
        IBlockCapabilityProvider<CAP, @Nullable Direction> providerForKind = bufferCapabilityProvider.specialize(resourceType.capabilityKind());
        event.registerBlockEntity(resourceTypeBlockCapability, SFMBlockEntities.BUFFER_BLOCK_ENTITY.get(), (blockEntity, direction) -> providerForKind.getCapability(blockEntity.getLevel(), blockEntity.getBlockPos(), blockEntity.getBlockState(), (BlockEntity)blockEntity, direction));
    }

    private static <T> IBlockCapabilityProvider<T, @Nullable Direction> createProvider(final BlockCapability<?, @Nullable Direction> cap) {
        return new IBlockCapabilityProvider<T, Direction>(){

            @Nullable
            public T getCapability(Level level, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, @Nullable Direction side) {
                if (side == null) {
                    return null;
                }
                BlockPos offset = blockPos.relative(side.getOpposite());
                return level.getCapability(cap, offset, (Object)side);
            }
        };
    }
}

